/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: netXAPI.h 7407 2015-12-03 13:37:07Z Robert $:

  Description:
    Global netX API definition for netX drivers

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2008-07-08  - xSysdevice/xChannel download included
    2008-02-19  - New error number included

    2008-02-01  - NXDRV_DEVICE_INFORMATION structure extended by
                  complete system information block
                - New error number included
    2007-11-09  created

**************************************************************************************/

/* prevent multiple inclusion */
#ifndef __NETxAPI_H
#define __NETxAPI_H

#pragma once

#include "CifxUser.h"

#ifdef __cplusplus
  extern "C" {
#endif  /* _cplusplus */


/*****************************************************************************
*! netX API Error Definition                                                
*****************************************************************************/
#define NXAPI_NO_ERROR                      0x00000000L

#define NXAPI_NOT_INITIALIZED               0x00000010L
#define NXAPI_NO_WORKING_DIRECTORY          0x00000011L
#define NXAPI_NO_ENTRIES                    0x00000012L
#define NXAPI_NO_ENTRY_FOUND                0x00000013L
#define NXAPI_UNKOWN_COMMAND                0x00000014L
#define NXAPI_INVALID_POINTER               0x00000015L
#define NXAPI_INVALID_PARAMETER             0x00000016L
#define NXAPI_BUFFER_TOO_SHORT              0x00000017L

#define NXAPI_DRIVER_NOT_INITIALIZED        0x00000020L
#define NXAPI_DRIVER_DLL_NOT_LOADED         0x00000021L
#define NXAPI_DRIVER_INTERFACE_MISSING      0x00000022L
#define NXAPI_DRIVER_FUNCTION_MISSING       0x00000023L
#define NXAPI_DRIVER_NO_DEVICE_FOUND        0x00000024L
#define NXAPI_DRIVER_DOWNLOAD_FAILED        0x00000025L
#define NXAPI_DRIVER_INVALID_COMMAND        0x00000026L

#define NXAPI_DRIVER_DIRECTORY_CREATE       0x00000030L
#define NXAPI_DRIVER_FILE_CREATE            0x00000031L
#define NXAPI_DRIVER_FILE_READ              0x00000032L
#define NXAPI_DRIVER_FILE_WRITE             0x00000032L
#define NXAPI_DRIVER_FILE_DELETE            0x00000032L

// Registry errors
#define NXAPI_DRIVER_REG_OPEN               0x00000040L
#define NXAPI_DRIVER_REG_CLOSE              0x00000041L

#define NXAPI_DRIVER_REG_ENUM_KEY           0x00000043L
#define NXAPI_DRIVER_REG_CREATE_KEY         0x00000044L
#define NXAPI_DRIVER_REG_DELETE_KEY         0x00000045L
#define NXAPI_DRIVER_REG_READ_KEY           0x00000046L

#define NXAPI_DRIVER_REG_ENUM_VALUE         0x00000047L
#define NXAPI_DRIVER_REG_CREATE_VALUE       0x00000048L
#define NXAPI_DRIVER_REG_DELETE_VALUE       0x00000049L
#define NXAPI_DRIVER_REG_READ_VALUE         0x0000004AL
#define NXAPI_DRIVER_REG_WRITE_VALUE        0x0000004BL



/*****************************************************************************
****  nxAPI Download Command definitions                                  ****
*****************************************************************************/
#define NXAPI_CMD_FIRMWARE                  0x00000001L
#define NXAPI_CMD_CONFIGURATION             0x00000002L
#define NXAPI_CMD_WARMSTART                 0x00000003L
#define NXAPI_CMD_BOOTLOADER                0x00000004L

/*****************************************************************************
****  nxAPI Configuration Command definitions                             ****
*****************************************************************************/
#define NXAPI_CMD_READ_DRIVER_CFG           0x00000001L
#define NXAPI_CMD_WRITE_DRIVER_CFG          0x00000002L
#define NXAPI_CMD_READ_CHANNEL_CFG          0x00000003L
#define NXAPI_CMD_WRITE_CHANNEL_CFG         0x00000004L

#define NXAPI_CMD_READ_FILE_CFG             0x00000005L
#define NXAPI_CMD_DELETE_FW_FILE            0x00000006L
#define NXAPI_CMD_DELETE_CFG_FILE           0x00000007L
#define NXAPI_CMD_DELETE_ALL_FILES          0x00000008L

#define NXAPI_CFG_DATATYPE_STRING           0x00000001L   // Null terminated string
#define NXAPI_CFG_DATATYPE_BINARY           0x00000003L   
#define NXAPI_CFG_DATATYPE_DWORD            0x00000004L  


/*****************************************************************************
****  INCLUDE FILES AND CONSTANT DEFINITIONS                              ****
*****************************************************************************/
#define NXDRV_NAME_LENGTH                   64
#define NXDRV_VERSION_LENGTH                64

// Global hardware driver type
#define NXDRV_TYPE_DPM                      0x00000001
#define NXDRV_TYPE_USB                      0x00000002
#define NXDRV_TYPE_SERIAL                   0x00000004
#define NXDRV_TYPE_ETH                      0x00000008

// Global driver Requirements
#define NXDRV_REQ_STARTUP_SW                0x00000001

// Command definitions 
#define NXDRV_FIND_FIRST                    	   1
#define NXDRV_FIND_NEXT                     	   2 

// Command definitions of Extended Name 
#define NXCON_GET_FULL_NAME                 	   1
#define NXCON_GET_SHORT_NAME                	   2

// defines of the nxCon functions
#define NXCON_MAX_LENGTH_CONNECTOR_IDENTIFIER    6
#define NXCON_UUID_STRING_SIZE                  37
#define NXCON_FILE_NAME_LENGTH                 256
#define NXCON_DESCRIPTION_LENGTH                64

/////////////////////////////////////////////////////
///  \typedef struct NXDRV_HW_INFORMATION 
/// Structure contains information about available
/// drivers
/////////////////////////////////////////////////////
typedef struct tagNXDRV_HW_INFORMATION 
{
  char                  szDriverName[NXDRV_NAME_LENGTH];            //!< Name of the driver
  char                  szVersion[NXDRV_NAME_LENGTH];               //!< Driver version 
  DWORD                 ulDriverType;                               //!< Driver type 
  DWORD                 ulDriverRequirements;                       //!< Driver requirements
  DWORD                 ulDeviceClass;                              //!< Supported device class
} NXDRV_HW_INFORMATION, *PNXDRV_HW_INFORMATION;

/////////////////////////////////////////////////////
///  \typedef struct NXDRV_DEVICE_INFORMATION
/// Structure contains the drivers device information.
/////////////////////////////////////////////////////
typedef struct tagNXDRV_DEVICE_INFORMATION
{
  HANDLE                            hDevice;                        //!< Device handle
  char                              szDeviceName[NXDRV_NAME_LENGTH];//!< Device name
  SYSTEM_CHANNEL_SYSTEM_INFO_BLOCK  tSystemInfoBlock;               //!< Device System Info Block
} NXDRV_DEVICE_INFORMATION, *PNXDRV_DEVICE_INFORMATION;

/////////////////////////////////////////////////////
///  \typedef struct NXDRV_DRIVER_CFG_DATA_INFO
/// Structure contains the driver configuration information.
/////////////////////////////////////////////////////
typedef struct tagNXDRV_DRIVER_CFG_DATA_INFO
{
  char                  szValueName[NXDRV_NAME_LENGTH];             //!< Value name
  DWORD                 ulValueIndex;                               //!< Value index
  DWORD                 ulValueType;                                //!< Value type
  DWORD                 ulValueSize;                                //!< Value size
} NXDRV_DRIVER_CFG_DATA_INFO, *PNXDRV_DRIVER_CFG_DATA_INFO;

 
typedef long(APIENTRY *PFN_NXDRV_INFO)( unsigned long ulSize, void* pvInfo);
typedef void(*PFN_NXAPI_PROGRESS_CALLBACK)(unsigned long ulStep, unsigned long ulMaxStep, void* pvUser, char bFinished, long lError);
typedef void(*PFN_NXAPI_BROWSE_CALLBACK)(unsigned long ulBoard, BOARD_INFORMATION* ptBoardInfo, unsigned long ulStep, unsigned long ulMaxStep, void* pvUser, char bFinished, long lError);

/////////////////////////////////////////////////////
///  netX API driver functions
/////////////////////////////////////////////////////
long APIENTRY nxDrvInit               ( void);
long APIENTRY nxDrvExit               ( void);
long APIENTRY nxDrvGetInformation     ( unsigned long         ulSize, 
                                        PNXDRV_HW_INFORMATION ptDrvInfo);
                                        
long APIENTRY nxDrvFindDevice         ( unsigned long             ulCmd,        unsigned long  ulInfoSize, 
                                        NXDRV_DEVICE_INFORMATION* ptDeviceInfo, unsigned long* pulSerachIdx);

long APIENTRY nxDrvBrowseDevices      ( PFN_NXAPI_BROWSE_CALLBACK pfnCallback, void* pvUser);

long APIENTRY nxDrvDownload           ( HANDLE        hDevice,      unsigned long ulChannel,  unsigned long ulCmd,
                                        unsigned long ulFileSize,   char* pszFileName, unsigned char* pabFileData, 
                                        void*         pvUser,       PFN_NXAPI_PROGRESS_CALLBACK pfnCallback);
                                        
long APIENTRY nxDrvStart              ( HANDLE hDevice, unsigned long ulChannel);

long APIENTRY nxDrvGetConfigInfo      ( HANDLE hDevice, unsigned long ulCmd, long lChannel, unsigned long ulSearchIndex, unsigned long ulBufferSize, NXDRV_DRIVER_CFG_DATA_INFO* ptCfgData);
long APIENTRY nxDrvGetConfig          ( HANDLE hDevice, unsigned long ulCmd, long lChannel, NXDRV_DRIVER_CFG_DATA_INFO* ptCfgData, unsigned long ulBufferSize, void* pvData);
long APIENTRY nxDrvSetConfig          ( HANDLE hDevice, unsigned long ulCmd, long lChannel, NXDRV_DRIVER_CFG_DATA_INFO* ptCfgData,  unsigned long ulBufferSize, void* pvData);
long APIENTRY nxDrvDeleteConfig       ( HANDLE hDevice, unsigned long ulCmd, long lChannel, NXDRV_DRIVER_CFG_DATA_INFO* ptCfgData);

/***************************************************************************
* Extension of nxAPI ( Connector extension )
***************************************************************************/
long APIENTRY nxConGetConfig          ( char* szUUID, unsigned long* pulConfigSize, char* pcConfig);
long APIENTRY nxConSetConfig          ( char* szUUID, char* pcConfig);
long APIENTRY nxConGetCorrespondName  ( char* szSourceName, unsigned long ulCmd, unsigned long ulCorrespondSize, char* szCorrespondName);
long APIENTRY nxConCreateConfigDialog ( char* szUUID, void* pvParentWnd, void** pvDialogWnd);
long APIENTRY nxConCloseConfigDialog  ( char* szUUID, BOOL fSaveChanges);
long APIENTRY nxConEnumerate          ( unsigned long ulConnectorIdx, unsigned long ulSize, void* pvConnectorInfo);

/***************************************************************************
* CIFX Device Driver API Functions
***************************************************************************/
/* Global driver functions */
typedef long (APIENTRY *PFN_DRVOPEN)                   ( CIFXHANDLE* phDriver);
typedef long (APIENTRY *PFN_DRVCLOSE)                  ( CIFXHANDLE  hDriver);
typedef long (APIENTRY *PFN_DRVGETINFORMATION)         ( CIFXHANDLE  hDriver, unsigned long ulSize, void* pvDriverInfo);
typedef long (APIENTRY *PFN_DRVGETERRORDESCRIPTION)    ( long        lError, char* szBuffer, unsigned long ulBufferLen);
typedef long (APIENTRY *PFN_DRVENUMBOARDS)             ( CIFXHANDLE  hDriver, unsigned long ulBoard, unsigned long ulSize, void* pvBoardInfo);
typedef long (APIENTRY *PFN_DRVENUMCHANNELS)           ( CIFXHANDLE  hDriver, unsigned long ulBoard, unsigned long ulChannel, unsigned long ulSize, void* pvChannelInfo);

/* System device depending functions */
typedef long (APIENTRY *PFN_SYSDEVICEOPEN)             ( CIFXHANDLE  hDriver, char*   szBoard, CIFXHANDLE* phSysdevice);
typedef long (APIENTRY *PFN_SYSDEVICECLOSE)            ( CIFXHANDLE  hSysdevice);
typedef long (APIENTRY *PFN_SYSDEVICEGETMBXSTATE)      ( CIFXHANDLE  hSysdevice, unsigned long* pulRecvPktCount, unsigned long* pulSendPktCount);
typedef long (APIENTRY *PFN_SYSDEVICEPUTPACKET)        ( CIFXHANDLE  hSysdevice, CIFX_PACKET* ptSendPkt, unsigned long ulTimeout);
typedef long (APIENTRY *PFN_SYSDEVICEGETPACKET)        ( CIFXHANDLE  hSysdevice, unsigned long ulSize, CIFX_PACKET* ptRecvPkt, unsigned long ulTimeout);
typedef long (APIENTRY *PFN_SYSDEVICEINFO)             ( CIFXHANDLE  hSysdevice, unsigned long ulCmd, unsigned long ulSize, void* pvInfo);

typedef long (APIENTRY *PFN_SYSDEVICEFINDFIRSTFILE)    ( CIFXHANDLE  hSysdevice, unsigned long ulChannel, CIFX_DIRECTORYENTRY* ptDirectoryInfo, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser);
typedef long (APIENTRY *PFN_SYSDEVICEFINDNEXTFILE)     ( CIFXHANDLE  hSysdevice, unsigned long ulChannel, CIFX_DIRECTORYENTRY* ptDirectoryInfo, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser);

typedef long (APIENTRY *PFN_SYSDEVICEDOWNLOAD)         ( CIFXHANDLE  hSysdevice, unsigned long ulChannel, unsigned long ulMode, char* pszFileName, unsigned char* pabFileData, unsigned long ulFileSize, 
                                                         PFN_PROGRESS_CALLBACK pfnCallback, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser);
typedef long (APIENTRY *PFN_SYSDEVICEUPLOAD)           ( CIFXHANDLE  hSysdevice, unsigned long ulChannel, unsigned long ulMode, char* pszFileName, unsigned char* pabFileData, unsigned long* pulFileSize, 
                                                         PFN_PROGRESS_CALLBACK pfnCallback, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser);

typedef long (APIENTRY *PFN_SYSDEVICERESET)            ( CIFXHANDLE  hSysdevice, unsigned long ulTimeout);

typedef long (APIENTRY *PFN_CHANNELOPEN)               ( CIFXHANDLE  hDriver,  char* szBoard, unsigned long ulChannel, CIFXHANDLE* phChannel);
typedef long (APIENTRY *PFN_CHANNELCLOSE)              ( CIFXHANDLE  hChannel);

typedef long (APIENTRY *PFN_CHANNELFINDFIRSTFILE)      ( CIFXHANDLE  hChannel, CIFX_DIRECTORYENTRY* ptDirectoryInfo, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser);
typedef long (APIENTRY *PFN_CHANNELFINDNEXTFILE)       ( CIFXHANDLE  hChannel, CIFX_DIRECTORYENTRY* ptDirectoryInfo, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser);

typedef long (APIENTRY *PFN_CHANNELDOWNLOAD)           ( CIFXHANDLE  hChannel, unsigned long ulMode, char* pszFileName, unsigned char* pabFileData, unsigned long ulFileSize, 
                                                         PFN_PROGRESS_CALLBACK pfnCallback, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser);
typedef long (APIENTRY *PFN_CHANNELUPLOAD)             ( CIFXHANDLE  hChannel, unsigned long ulMode, char* pszFileName, unsigned char* pabFileData, unsigned long* pulFileSize,
                                                         PFN_PROGRESS_CALLBACK pfnCallback, PFN_RECV_PKT_CALLBACK pfnRecvPktCallback, void* pvUser);

typedef long (APIENTRY *PFN_CHANNELGETMBXSTATE)        ( CIFXHANDLE  hChannel, unsigned long* pulRecvPktCount, unsigned long* pulSendPktCount);
typedef long (APIENTRY *PFN_CHANNELPUTPACKET)          ( CIFXHANDLE  hChannel, CIFX_PACKET*  ptSendPkt, unsigned long ulTimeout);
typedef long (APIENTRY *PFN_CHANNELGETPACKET)          ( CIFXHANDLE  hChannel, unsigned long ulSize, CIFX_PACKET* ptRecvPkt, unsigned long ulTimeout);

typedef long (APIENTRY *PFN_CHANNELCONTROLBLOCK)       ( CIFXHANDLE  hChannel, unsigned long ulCmd, unsigned long ulOffset, unsigned long ulDataLen, void* pvData);
typedef long (APIENTRY *PFN_CHANNELCOMMONSTATUSBLOCK)  ( CIFXHANDLE  hChannel, unsigned long ulCmd, unsigned long ulOffset, unsigned long ulDataLen, void* pvData);
typedef long (APIENTRY *PFN_CHANNELEXTENDEDSTATUSBLOCK)( CIFXHANDLE  hChannel, unsigned long ulCmd, unsigned long ulOffset, unsigned long ulDataLen, void* pvData);
typedef long (APIENTRY *PFN_CHANNELUSERBLOCK)          ( CIFXHANDLE  hChannel, unsigned long ulAreaNumber, unsigned long ulCmd, unsigned long ulOffset, unsigned long ulDataLen, void* pvData);

typedef long (APIENTRY *PFN_CHANNELCONFIGLOCK)         ( CIFXHANDLE  hChannel, unsigned long ulCmd, unsigned long* pulState, unsigned long ulTimeout);
typedef long (APIENTRY *PFN_CHANNELRESET)              ( CIFXHANDLE  hChannel, unsigned long ulResetMode, unsigned long ulTimeout);
typedef long (APIENTRY *PFN_CHANNELINFO)               ( CIFXHANDLE  hChannel, unsigned long ulSize, void* pvChannelInfo);
typedef long (APIENTRY *PFN_CHANNELHOSTSTATE)          ( CIFXHANDLE  hChannel, unsigned long ulCmd, unsigned long* pulState, unsigned long ulTimeout);
typedef long (APIENTRY *PFN_CHANNELBUSSTATE)           ( CIFXHANDLE  hChannel, unsigned long ulCmd, unsigned long* pulState, unsigned long ulTimeout);
typedef long (APIENTRY *PFN_CHANNELIOINFO)             ( CIFXHANDLE  hChannel, unsigned long ulCmd,        unsigned long ulAreaNumber, unsigned long ulSize, void* pvData);
typedef long (APIENTRY *PFN_CHANNELIOREAD)             ( CIFXHANDLE  hChannel, unsigned long ulAreaNumber, unsigned long ulOffset,     unsigned long ulDataLen, void* pvData, unsigned long ulTimeout);
typedef long (APIENTRY *PFN_CHANNELIOWRITE)            ( CIFXHANDLE  hChannel, unsigned long ulAreaNumber, unsigned long ulOffset,     unsigned long ulDataLen, void* pvData, unsigned long ulTimeout);


typedef struct NXDRV_FUNCTION_TABLEtag
{
  // The cifX API interface
  PFN_DRVOPEN                     pfnDriverOpen;                                /*!< xDriverOpen                    */
  PFN_DRVCLOSE                    pfnDriverClose;                  
  PFN_DRVGETINFORMATION           pfnDriverGetInformation;         
  PFN_DRVGETERRORDESCRIPTION      pfnDriverGetErrorDescription;    
  PFN_DRVENUMBOARDS               pfnDriverEnumBoards;
  PFN_DRVENUMCHANNELS             pfnDriverEnumChannels;
  
  // System channel functions
  PFN_SYSDEVICEOPEN               pfnSysdeviceOpen;
  PFN_SYSDEVICECLOSE              pfnSysdeviceClose;
  PFN_SYSDEVICEGETMBXSTATE        pfnSysdeviceGetMBXState;
  PFN_SYSDEVICEPUTPACKET          pfnSysdevicePutPacket;
  PFN_SYSDEVICEGETPACKET          pfnSysdeviceGetPacket;
  PFN_SYSDEVICEINFO               pfnSysdeviceInfo;
  PFN_SYSDEVICEFINDFIRSTFILE      pfnSysdeviceFindFirstFile;
  PFN_SYSDEVICEFINDNEXTFILE       pfnSysdeviceFindNextFile;
  
  PFN_SYSDEVICEDOWNLOAD           pfnSysdeviceDownload;
  PFN_SYSDEVICEUPLOAD             pfnSysdeviceUpload;
  
  PFN_SYSDEVICERESET              pfnSysdeviceReset;
  
  // Communication channel functions
  PFN_CHANNELOPEN                 pfnChannelOpen;
  PFN_CHANNELCLOSE                pfnChannelClose;
  PFN_CHANNELFINDFIRSTFILE        pfnChannelFindFirstFile;
  PFN_CHANNELFINDNEXTFILE         pfnChannelFindNextFile;
  
  PFN_CHANNELDOWNLOAD             pfnChannelDownload;
  PFN_CHANNELUPLOAD               pfnChannelUpload;
  
  PFN_CHANNELGETMBXSTATE          pfnChannelGetMBXState;
  PFN_CHANNELPUTPACKET            pfnChannelPutPacket;
  PFN_CHANNELGETPACKET            pfnChannelGetPacket;

  PFN_CHANNELCONTROLBLOCK         pfnChannelControlBlock;
  PFN_CHANNELCOMMONSTATUSBLOCK    pfnChannelCommonStatusBlock;
  PFN_CHANNELEXTENDEDSTATUSBLOCK  pfnChannelExtendedStatusBlock;
//  PFN_CHANNELUSERBLOCK            pfnChannelUserBlock;
  
  PFN_CHANNELCONFIGLOCK           pfnChannelConfigLock;
  PFN_CHANNELRESET                pfnChannelReset;
  PFN_CHANNELINFO                 pfnChannelInfo;
  PFN_CHANNELHOSTSTATE            pfnChannelHostState;
  PFN_CHANNELBUSSTATE             pfnChannelBusState;
  PFN_CHANNELIOINFO               pfnChannelIOInfo;
  PFN_CHANNELIOREAD               pfnChannelIORead;
  PFN_CHANNELIOWRITE              pfnChannelIOWrite;

} NXDRV_FUNCTION_TABLE, *PNXDRV_FUNCTION_TABLE;  

/////////////////////////////////////////////////////
///  \typedef struct NXDRV_INFORMATION
/// Structure contains the cifX driver information about available
/// driver DLLs
/////////////////////////////////////////////////////
typedef struct tagNXDRV_INFORMATION
{
  HANDLE                hDriver;
  long                  lError;
  NXDRV_FUNCTION_TABLE* ptFnc;
} NXDRV_INFORMATION, *PNXDRV_INFORMATION;

/***************************************************************************
* Extension of nxAPI ( Connector extension )
***************************************************************************/
/////////////////////////////////////////////////////
///  \typedef struct NXCON_CONNECTOR_INFO_T
/// Structure contains the connector information of a available connector
/////////////////////////////////////////////////////
typedef struct NXCON_CONNECTOR_INFO_Ttag
{
  char          szConnectorUUID[NXCON_UUID_STRING_SIZE];              /*!< UUID of the selected connector             */
  char          szIdentifier[NXCON_MAX_LENGTH_CONNECTOR_IDENTIFIER];  /*!< Identifier of the connector                */
  char          szFileName[NXCON_FILE_NAME_LENGTH];                   /*!< File name of the connector                 */                 
  char          szFullFileName[NXCON_FILE_NAME_LENGTH];               /*!< Full file name of the connector            */
  char          szDescription[NXCON_DESCRIPTION_LENGTH];              /*!< Description of the connector               */
  unsigned long ulConnectorType;                                      /*!< Supported types of the selected connector  */
} NXCON_CONNECTOR_INFO_T, *PNXCON_CONNECTOR_INFO_T;

/***************************************************************************/

#ifdef __cplusplus
}
#endif

/*****************************************************************************/
/*! \}                                                                       */
/*****************************************************************************/

#endif  /* __NETxAPI_H */
